/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelMutexInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int initCount;
    public int lockedCount;
    public final ThreadWaitingList threadWaitingList;
    public final int uid;
    public int threadid;

    public SceKernelMutexInfo(String name, int count, int attr) {
        this.name = name;
        this.attr = attr;
        this.initCount = count;
        this.lockedCount = count;
        this.threadid = count > 0 ? Modules.ThreadManForUserModule.getCurrentThreadID() : -1;
        this.uid = SceUidManager.getNewUid("ThreadMan-Mutex");
        this.threadWaitingList = ThreadWaitingList.createThreadWaitingList(12, this.uid, attr, 256);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.initCount);
        this.write32(this.lockedCount);
        this.write32(this.threadid);
        this.write32(this.getNumWaitingThreads());
    }

    public int getNumWaitingThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelMutexInfo(uid=0x%X, name='%s', attr=0x%X, initCount=%d, lockedCount=%d, numWaitThreads=%d)", this.uid, this.name, this.attr, this.initCount, this.lockedCount, this.getNumWaitingThreads());
    }
}

